/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.network;

import com.rwtema.monkmod.network.MessageBlink;
import com.rwtema.monkmod.network.MessageMonkLevelData;
import com.rwtema.monkmod.network.MessageProgress;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MonkNetwork {
    public static SimpleNetworkWrapper net;

    public static void init() {
        net = new SimpleNetworkWrapper("MonkNetwork");
        IMessageHandler genericHandler = (message, ctx) -> {
            message.onReceived(ctx);
            return null;
        };
        MonkNetwork.registerClientToServerPacket((IMessageHandler<MessageBase, IMessage>)genericHandler, MessageBlink.class, 0);
        MonkNetwork.registerServerToClientPacket((IMessageHandler<MessageBase, IMessage>)genericHandler, MessageMonkLevelData.class, 1);
        MonkNetwork.registerServerToClientPacket((IMessageHandler<MessageBase, IMessage>)genericHandler, MessageProgress.class, 2);
    }

    private static <T extends MessageServerToClient> void registerServerToClientPacket(@Nonnull IMessageHandler<MessageBase, IMessage> genericHandler, Class<T> messageType, int discriminator) {
        net.registerMessage(genericHandler, messageType, discriminator, Side.CLIENT);
    }

    private static <T extends MessageClientToServer> void registerClientToServerPacket(@Nonnull IMessageHandler<MessageBase, IMessage> genericHandler, Class<T> messageType, int discriminator) {
        net.registerMessage(genericHandler, messageType, discriminator, Side.SERVER);
    }

    public static abstract class MessageServerToClient
    extends MessageBase {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void onReceived(MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.runClient(ctx, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }

        @SideOnly(value=Side.CLIENT)
        protected abstract void runClient(MessageContext var1, EntityPlayer var2);
    }

    public static abstract class MessageClientToServer
    extends MessageBase {
        @Override
        public void onReceived(@Nonnull MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.runServer(ctx, player));
        }

        protected abstract void runServer(MessageContext var1, EntityPlayerMP var2);

        public void writeNBT(NBTTagCompound tag, @Nonnull ByteBuf buf) {
            new PacketBuffer(buf).func_150786_a(tag);
        }

        @Nullable
        public NBTTagCompound readNBT(@Nonnull ByteBuf bf) {
            try {
                return new PacketBuffer(bf).func_150793_b();
            }
            catch (IOException e) {
                throw new DecoderException((Throwable)e);
            }
        }
    }

    public static abstract class MessageBase
    implements IMessage {
        public void onReceived(MessageContext ctx) {
        }
    }
}

